<?php
/**
 * Class jQuery_Migrate_Helper,
 *
 */
if (!defined( 'ABSPATH')) {
	die('Invalid request.');
}

class jQuery_Migrate_Helper {

	private function __construct() {}

	public static function init_actions() {
		// To be able to replace the src, scripts should not be concatenated.
		if (!defined('CONCATENATE_SCRIPTS')) {
			define('CONCATENATE_SCRIPTS', false);
		}
		$GLOBALS['concatenate_scripts']     = false;
        add_action('wp_default_scripts', array( __CLASS__, 'replace_scripts'), -1);
	}

	// Pre-register scripts on 'wp_default_scripts' action, they won't be overwritten by $wp_scripts->add().
	private static function set_script($scripts, $handle, $src, $deps = array(), $ver = false, $in_footer = false) {
		$script                             = $scripts->query($handle, 'registered');
		if ($script) {
			// If already added
			$script->src                    = $src;
			$script->deps                   = $deps;
			$script->ver                    = $ver;
			$script->args                   = $in_footer;
			unset($script->extra['group']);
			if ($in_footer) {
				$script->add_data( 'group', 1);
			}
		} else {
			// Add the script
			if ($in_footer) {
				$scripts->add($handle, $src, $deps, $ver, 1);
			} else {
				$scripts->add($handle, $src, $deps, $ver);
			}
		}
	}

	/*
	 * Enqueue jQuery Migrate Library
	 *
	 */
	public static function replace_scripts($scripts) {
        global $VISUAL_COMPOSER_EXTENSIONS;
		self::set_script($scripts, 'jquery-migrate', $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_PluginPath . 'js/jquery.vcsc.jquerymigrate.min.js', array(), '1.4.1');
		self::set_script($scripts, 'jquery', false, array('jquery-core', 'jquery-migrate' ), '1.12.4');
    }
}
